<?php

namespace App\Models\Orgs;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class User extends Model 
{

    protected $table = 'users';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('bonus_limit');

    public function getInstitutionsResponsibleFor()
    {
        return $this->hasMany('App\Models\Orgs\Institution', 'responsible_id');
    }

    public function getEventFacts()
    {
        return $this->hasMany('App\Models\Events\EventFacts');
    }

    public function getChallenges()
    {
        return $this->hasMany('App\Models\Challenges\Challenge');
    }

    public function getQuizes()
    {
        return $this->hasMany('App\Models\Quizes\Quiz');
    }

    public function getInstitution()
    {
        return $this->belongsTo('App\Models\Orgs\Institution');
    }

    public function getActivities()
    {
        return $this->hasMany('App\Models\Activities\Activity');
    }

    public function getOwnedGroups()
    {
        return $this->hasMany('App\Models\Students\Group', 'owner_user_id');
    }

}